import matplotlib.pyplot as plt


"""
This file is to create a pie chart of 

@author: Jonathan van Oudheusden
@date: 2024-01-28

Required files: 
    - none, however manually sum the count of the codes in each theme,
    to get the final size of each theme
    
Output files:
    - piechart.png
"""

# Example data for Tree Map 
data = [181, 148, 146, 137, 114, 98]  # Sizes of rectangles
labels = ["Motivational Deficits", "Motivation and mindset", "Embracing Positivity", "Behavioral Changes", "Negative Aspects Awareness", "Emotional and Cognitive Changes"]  # Labels for rectangles

# Convert counts to percentages
total = sum(data)
sizes = [count / total * 100 for count in data]

plt.figure(figsize=(15, 8)) 
plt.pie(sizes, labels=labels, autopct='%1.1f%%', startangle=140)
plt.legend(labels, title="Themes", loc="center left", bbox_to_anchor=(1, 0.5))
plt.axis('equal') 
plt.title('Example Pie Chart')
plt.tight_layout()

plt.title('Composition of Themes')
plt.savefig('piechart.png')